using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Szkolenie_Start
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        //BasicEffect efekt;
        //VertexBuffer buforWerteksow;

        Model model;

        Effect efekt;
        Matrix World, View, Projection;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            this.IsMouseVisible = true;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            Projection = Matrix.CreatePerspective(
                2f * graphics.GraphicsDevice.Viewport.AspectRatio,
                2,
                1f,
                100f);
            View = Matrix.CreateLookAt(new Vector3(0, 0, 2.5f), Vector3.Zero, Vector3.Up);
            World = Matrix.Identity;

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            efekt = Content.Load<Effect>("efekt");
            efekt.Parameters["WorldViewProjection"].SetValue(World * View * Projection);
            efekt.Parameters["Kolor"].SetValue(Color.CornflowerBlue.ToVector4());

            model = Content.Load<Model>("teapot");

            foreach (ModelMesh siatka in model.Meshes)
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    czescSiatki.Effect = efekt;
                }
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        KeyboardState poprzedniStanKlawiatury = Keyboard.GetState();

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (!this.IsActive) return;

            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            if (Keyboard.GetState().IsKeyDown(Keys.Space) && poprzedniStanKlawiatury.IsKeyDown(Keys.Space)) this.graphics.ToggleFullScreen();
            if (Keyboard.GetState().IsKeyDown(Keys.Escape) && poprzedniStanKlawiatury.IsKeyDown(Keys.Escape)) this.Exit();
            poprzedniStanKlawiatury = Keyboard.GetState();

            World *= Matrix.CreateRotationY((float)(gameTime.ElapsedGameTime.TotalMilliseconds*0.001));
            efekt.Parameters["WorldViewProjection"].SetValue(World * View * Projection);

            efekt.Parameters["Czas"].SetValue((float)gameTime.TotalGameTime.TotalSeconds);

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            if (!this.IsActive) return;
            //GraphicsDevice.Clear(Color.CornflowerBlue);

            GraphicsDevice gd = this.GraphicsDevice;
            gd.Clear(Color.Black);

            foreach (ModelMesh siatka in model.Meshes)
            {
                foreach (Effect efekt in siatka.Effects)
                    siatka.Draw();
            }

            base.Draw(gameTime);
        }
    }
}
